<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class NotificacionSolicitud extends Model 
{

    protected $table = 'notificaciones_solicitud';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('notificacion_id', 'solicitud_id', 'fecha');
    protected $visible = array('notificacion_id', 'solicitud_id', 'fecha');

    public function solicitud()
    {
        return $this->belongsTo('Solicitud', 'solicitud_id')->withTrashed();
    }

    public function notificacion()
    {
        return $this->belongsTo('Notificacion', 'notificacion_id')->withTrashed();
    }

}